﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.EFR;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class PatientWorkflows : BasePage
{
    private const string DateFormat = "M/d/yyyy";

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/Patients.aspx",
        "/Patient.aspx",
        "/Referral.aspx",
        "/PatientRelatedDiagnoses.aspx",
        "/PatientRelatedLabTests.aspx",
        "/PatientImaging.aspx"
    };

    private readonly EFRPatientManager _manager;
    private readonly PatientImagingManager _patientImagingManager;
    private PatientImageAnalysis _patientImageAnalysis;


    public string ImagingDateReviewed
    {
        get
        {
            if (_patientImageAnalysis != null && _patientImageAnalysis.DateReviewed.HasValue)
                return _patientImageAnalysis.DateReviewed.Value.ToString(DateFormat);
            return string.Empty;
        }
    }

    public string ImagingFragmentVerified
    {
        get
        {
            if (_patientImageAnalysis != null && _patientImageAnalysis.FragmentVerifiedFlag.HasValue)
                return _patientImageAnalysis.FragmentVerifiedFlag.Value ? "Yes" : "No";
            return string.Empty;
        }
    }

    public PatientWorkflows()
    {
        _patientImagingManager = new PatientImagingManager();
        _manager = new EFRPatientManager();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int patientId;
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
            {
                PATIENT patient = _manager.SelectByID(patientId);

                BreadCrumbLabel.Text = BreadCrumbLabel.Text + patient.FullName;

                _patientImageAnalysis = _patientImagingManager.GetPatientImageAnalysis(patient.PATIENT_ICN);
            }

            SetReferringPage();
        }
    }

    protected void EFRPatientReferrals_ItemCreated(object source, RepeaterItemEventArgs e)
    {
    }

    protected void EFRPatientReferrals_DataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            //have to set parameter of inner repeater here - V.S.
            ObjectDataSource casesSource = e.Item.FindControl("ObjectDataSourceReferralWorkflows") as ObjectDataSource;
            var ReferralIDField = e.Item.FindControl("ReferralIDField") as HiddenField;

            if (ReferralIDField != null && casesSource != null)
            {
                casesSource.SelectParameters["referralId"].DefaultValue = ReferralIDField.Value;
            }


            var item = e.Item.DataItem as ReferralManager.ReferralsGetListByPatientResult;

            if (item != null)
            {
                if (item.ContactLogsCount == 0)
                {
                    Button btnContacts = e.Item.FindControl("btnContacts") as Button;
                    if (btnContacts != null)
                    {
                        btnContacts.Enabled = false;
                    }
                }
                var numFragFiles = SqlProvider.ExecuteScalar(
                "RegistryConnectionString", "usp_EFR_GetDoDFragmentFilesCountByPatientId", new object[] { item.PatientId });

                Button buttonDoDFragment = e.Item.FindControl("ButtonViewDoDFragment") as Button;
                Button buttonDoDFragmentRawData = e.Item.FindControl("ButtonViewDoDFragmentRawData") as Button;

                if (numFragFiles != DBNull.Value && Convert.ToInt32(numFragFiles) > 0
                    && ((CurrentUser.IsInRole(EFRSharedConstant.EfrUserRoleTefscCoordinator)
                        || CurrentUser.IsInRole(EFRSharedConstant.EfrUserRoleNurse)
                        || CurrentUser.IsInRole(EFRSharedConstant.EfrUserRoleProvider))
                        ))
                {
                    if (buttonDoDFragment != null && buttonDoDFragmentRawData != null)
                    {
                        buttonDoDFragment.Enabled = true;
                        buttonDoDFragmentRawData.Enabled = true;
                    }
                }
                else
                {
                    if (buttonDoDFragment != null && buttonDoDFragmentRawData != null)
                    {
                        buttonDoDFragment.Enabled = false;
                        buttonDoDFragmentRawData.Enabled = false;
                    }
                }

                Label lblNoWorkflows = e.Item.FindControl("labelNoWorkflows") as Label;
                if (lblNoWorkflows != null)
                {
                    if (item.ReferralWorkflowCount == 0)
                    {
                        lblNoWorkflows.Visible = true;
                    }
                    else
                    {
                        lblNoWorkflows.Visible = false;
                    }
                }
            }
        }
    }

    protected void ReferralCases_DataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            //have to set parameter of inner repeater here - V.S.
            ObjectDataSource activitiesSource = e.Item.FindControl("ObjectDataSourceActivities") as ObjectDataSource;
            var CaseIDField = e.Item.FindControl("CaseIDField") as HiddenField;
            if (CaseIDField != null && activitiesSource != null)
            {
                activitiesSource.SelectParameters["caseId"].DefaultValue = CaseIDField.Value;
                activitiesSource.SelectParameters["caseTypeId"].DefaultValue = ((HiddenField)e.Item.FindControl("CaseTypeIDField")).Value;
            }
        }
    }

    protected void EFRPatientReferrals_ItemCommand(object source, RepeaterCommandEventArgs e)
    {

        HiddenField hiddenID = (HiddenField)e.Item.FindControl("ReferralIDField");
        HiddenField hiddenPatientID = (HiddenField)e.Item.FindControl("HiddenFieldPatientId");
        string id = hiddenID.Value;

        if (e.CommandName.Equals("Referral"))
        {

            Response.Redirect(string.Format("Referral.aspx?referralId={0}&from=workFlow", id));

        }
        else if (e.CommandName.Equals("ContactLogs"))
        {
            Response.Redirect(string.Format("ReferralContactLog.aspx?referralId={0}", id));

        }
        else if (e.CommandName.Equals("ViewDoDFragment"))
        {
            Response.Redirect(string.Format("DoDFragment.aspx?patientId={0}", hiddenPatientID.Value));
        }
        else if (e.CommandName.Equals("ViewDoDFragmentRawData"))
        {
            Response.Redirect(string.Format("DoDFragmentRawData.aspx?patientId={0}", hiddenPatientID.Value));
        }
    }

    protected void ReferralActivities_RowCommand(object source, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "ActivityDetails")
        {
            int index = Convert.ToInt32(e.CommandArgument);

            GridView gv = source as GridView;
            if (gv != null)
            {
                gv.SelectedIndex = index;
            }
            string activityId = string.Empty;
            string typeId = string.Empty;
            string caseTypeId = string.Empty;
            string caseId = string.Empty;
            if (gv != null)
            {
                activityId = gv.SelectedDataKey.Values["CaseActivityId"].ToString();
                typeId = gv.SelectedDataKey.Values["CaseActivityTypeId"].ToString();
                caseTypeId = ((HiddenField)gv.NamingContainer.FindControl("CaseTypeIDField")).Value;
                caseId = ((HiddenField)gv.NamingContainer.FindControl("CaseIdField")).Value;
            }

            if (int.Parse(typeId) == 1)
            {
                Response.Redirect("LabKitDetails.aspx?ActivityId={0}", activityId);
            }
            else if (int.Parse(typeId) == 2)
            {
                Response.Redirect("SurveyLink.aspx?activityId={0}", activityId);

            }
            else if (int.Parse(typeId) == 3)
            {
                if (int.Parse(caseTypeId) == 3)
                    Response.Redirect("LabOrder.aspx?activityId={0}", activityId);
                else if (int.Parse(caseTypeId) == 4)
                    Response.Redirect("FragLabOrder.aspx?activityId={0}", activityId);
            }
            else if (int.Parse(typeId) == 4)
            {
                if (int.Parse(caseTypeId) == 3)
                    Response.Redirect("LabResultDetails.aspx?activityId={0}", activityId);
                else if (int.Parse(caseTypeId) == 4)
                    Response.Redirect("FragLabResultDetails.aspx?activityId={0}", activityId);
            }
            else if (int.Parse(typeId) == 22)
            {
                if (int.Parse(caseTypeId) == 3)
                    Response.Redirect("BioLabInterpretation.aspx?CaseId={0}", caseId);
                else if (int.Parse(caseTypeId) == 4)
                    Response.Redirect("FragLabInterpretation.aspx?CaseId={0}", caseId);
            }
        }
    }

    public string BioFollowUpText(object followups)
    {
        StringBuilder sb = new StringBuilder();

        if (followups is List<WKF_CASE_ACTIVITY>)
        {
            List<WKF_CASE_ACTIVITY> reminderList = followups as List<WKF_CASE_ACTIVITY>;
            if (reminderList != null)
            {
                foreach (var elem in reminderList)
                {
                    if (elem.FOLLOWUP_PLAN_DATE.HasValue)
                    {
                        sb.Append("&nbsp;This Referral needs Follow Up Biomonitoring, due " + elem.FOLLOWUP_PLAN_DATE.Value.ToString("d"));
                        sb.Append("<br/><br/>");
                    }
                }
            }

        }
        return sb.ToString();
    }
    public string SelectContactText(object count)
    {

        if (int.Parse(count.ToString()) == 0)

            return "&nbsp;This referral has no contact entries.";

        else if (int.Parse(count.ToString()) == 1)

            return "&nbsp;This referral has 1 contact entry.";

        else

            return "&nbsp;This referral has&nbsp;" + int.Parse(count.ToString()) + "&nbsp;contact entries.";

    }

    public string OutOfThisText(object count)
    {
        if (int.Parse(count.ToString()) == 1)

            return "&nbsp;Out of this&nbsp;" + Eval("ContactLogsCount") + "&nbsp;contact entry,&nbsp;";

        else

            return "&nbsp;Out of these&nbsp;" + Eval("ContactLogsCount") + "&nbsp;contact entries,&nbsp;";
    }

    public string NeedText(object count)
    {
        if (int.Parse(count.ToString()) == 1)

            return "needs";

        else

            return "need";

    }

    protected void CancelButton_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

}
